//  Copyright 2019 mobileknowledge. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "NTAG5_NFC_LIB.h"
#import "ISO15693Command.h"
#import "RFCommands.h"
#import "NSData+FastHex.h"
#import <math.h>
#import "NTAG5Strings.h"

NS_ASSUME_NONNULL_BEGIN

@interface PWMUseCase: NSObject

+ (PWMUseCase *) sharedInstance;

/*!
*@abstract  reads PWM config and session registers
**/
- (void) readPWM:(void (^)(NSData *aData, const int order))success  onFailure : (void(^)(NSError *error))failure;

/*!
 *@abstract   writes to PWM config and session registers
 **/
- (void) writePWM: (ISO15693Command *) pwmConfig pwm0Command: (ISO15693Command *) pwm0Command pwm1Command: (ISO15693Command *) pwm1Command onSuccess:(void (^)(NSData *aData))success  onFailure : (void(^)(NSError *error))failure;

@end

NS_ASSUME_NONNULL_END
